/* ******************************************************************************
 * 	VSCP (Very Simple Control Protocol) 
 * 	http://www.vscp.org
 *
 *  2014 David Steeman
 *
 * This software is provided 'as-is', without any express or implied
 * warranty.  In no event will the authors be held liable for any damages
 * arising from the use of this software.
 *
 * Permission is granted to anyone to use this software for any purpose,
 * including commercial applications, and to alter it and redistribute it
 * freely, subject to the following restrictions:
 *
 * 1. The origin of this software must not be misrepresented; you must not
 *    claim that you wrote the original software. If you use this software
 *    in a product, an acknowledgement in the product documentation would be
 *    appreciated but is not required.
 * 2. Altered source versions must be plainly marked as such, and must not be
 *    misrepresented as being the original software.
 * 3. This notice may not be removed or altered from any source distribution.
 * 
 *	This file is part of VSCP - Very Simple Control Protocol 	
 *	http://www.vscp.org
 *
 * ******************************************************************************
*/
/*
 * IO definition for Mespelare v9 board
 */

#ifndef MESPELARE
#define MESPELARE

// Firmware version

#define FIRMWARE_MAJOR_VERSION		1
#define FIRMWARE_MINOR_VERSION		9
#define FIRMWARE_SUB_MINOR_VERSION	4
#define VSCP_FPM_DEFAULT_NICK           0x600
#define VSCP_FPM_GUID                   0x602   //location in program flash where node GUID is stored (programmed together with bootloader)


//Timer0 used as 10ms timer. Timer generates interupt on overflow.
#define Timer0Prescaler                 T0_PS_1_2
//#define Timer0ReloadValue               25536  // 10ms = 80000 clock ticks at 8Mhz Fosc/4. Prescaler = 1/2. Timer0ReloadValue=65536-40000=25536 (prescaler: 1/2)
//#define Timer0ReloadValue               61536  //(theoretical value) 1ms = 8000 clock ticks at 8Mhz Fosc/4. Prescaler = 1/2. Timer0ReloadValue=65536-4000=61536
#define Timer0ReloadValue               61566  //(works on my PIC) 1ms = 8000 clock ticks at 8Mhz Fosc/4. Prescaler = 1/2. Timer0ReloadValue=65536-4000=61536 

//#define Timer0Prescaler                 T0_PS_1_1
//#define Timer0ReloadValue               64736  // 0,1ms


//// * * * I/O Definitions * * *

//#define PWMaudio                                                        CCPR1L
#define PWM1								CCPR1L
#define PWM2								CCPR5L

#define INIT_LED    LATDbits.LATD6
#define BUZZER      LATDbits.LATD2
#define INIT_BUTTON PORTCbits.RC7
#define SDA_PIN     LATCbits.LATC4
#define SCL_PIN     LATCbits.LATC3
#define ONEWIRE_PIN LATCbits.LATC5

#ifdef DEBUG_DEBUGPIN
#define DEBUG_PIN  LATDbits.LATD5  // pin used for debugging, not connected on Mespelare v9 hardware
#endif

#define OUT1        LATBbits.LATB7
#define OUT2        LATAbits.LATA0
#define OUT3        LATAbits.LATA1   //PWM5 out -> output or PWM
#define OUT4        LATAbits.LATA2   //PWM1 out -> output or PWM
#define OUT5        LATAbits.LATA3
#define OUT6        LATAbits.LATA5   //D0
#define OUT7        LATEbits.LATE0   //D1
#define OUT8        LATEbits.LATE1   //D1
#define OUT9        LATEbits.LATE2
#define OUT10       LATCbits.LATC0
#define OUT11       LATCbits.LATC1
#define OUT12       LATCbits.LATC2
#define OUT13       LATDbits.LATD0
#define OUT14       LATDbits.LATD1
#define OUT15       BUZZER

//defines for ds18s20.h and ow.h drivers
#define OW_LAT      LATCbits.LATC5
#define OW_PIN      PORTCbits.RC5
#define OW_TRIS     TRISCbits.TRISC5

//defines for ds1820.h and types.h drivers
#define DS1820_DATAPIN  ONEWIRE_PIN

#define INP1        PORTDbits.RD7
#define INP2        PORTBbits.RB0
#define INP3        PORTBbits.RB1
#define INP4        PORTBbits.RB4
#define INP5        PORTBbits.RB5
#define INP6        PORTBbits.RB6
#define INP7        PORTCbits.RC6
#define INP8        PORTCbits.RC6 // works, mapped to above



// * * * Values * * *
#define DEBOUNCE_CHECKS     5 // # checks before a switch is debounced

#define INP_RELEASED                                            0x04
#define INP_PRESSED                                             0x01
#define INP_HOLD                                                0x03
#define INP_HOLD_REPEAT                                         0x05
#define INP_KEY							0x02

#define OUTPUT_ON                                               1
#define OUTPUT_OFF                                              0

#define PULSE_OUT_PERIOD                                        10              // period of the pulse in multiples of 10ms (10 = 100ms)

//Registers 0x00?0x7F (0-127) are application specific. Registers between 0x80?0xFF (128-255) are reserved for VSCP usage. If the node has implemented the decision matrix it is stored in application register space.
//format: #define FIRMWARE_REGISTER_NAME    256 * page + register (app registers = 0 - 127)
//VSCP reserved registers are not set here, there's set in eslsewhere in the code //TODO: where?

// * * * User defined Registers * * *
#define USER_EEPROM_OFFSET                                      VSCP_EEPROM_END

#define REG_DESCISION_MATRIX					(256* 0 + 90)  // Start of matrix, 256 = page 1:0
#define DESCISION_MATRIX_ELEMENTS                               4              // # of DM registers = # elements * 8

#define EEPROM_ZONE						(256* 0 + 0)   //Zone node belongs to
#define EEPROM_SUBZONE						(256* 0 + 1)   //Subzone node belongs to

#define REG_STATUS_OUT1                                         (256* 0 + 2)
#define REG_STATUS_OUT2                                         (256* 0 + 3)
#define REG_STATUS_OUT3                                         (256* 0 + 4)
#define REG_STATUS_OUT4                                         (256* 0 + 5)
#define REG_STATUS_OUT5                                         (256* 0 + 6)
#define REG_STATUS_OUT6                                         (256* 0 + 7)
#define REG_STATUS_OUT7                                         (256* 0 + 8)
#define REG_STATUS_OUT8                                         (256* 0 + 9)
#define REG_STATUS_OUT9                                         (256* 0 + 10)
#define REG_STATUS_OUT10                                        (256* 0 + 11)
#define REG_STATUS_OUT11                                        (256* 0 + 12)
#define REG_STATUS_OUT12                                        (256* 0 + 13)
#define REG_STATUS_OUT13                                        (256* 0 + 14)
#define REG_STATUS_OUT14                                        (256* 0 + 15)
#define REG_STATUS_OUT15                                        (256* 0 + 16)  //  buzzer

#define REG_CONTROL_OUT1                                        (256* 0 + 17)
#define REG_CONTROL_OUT2                                        (256* 0 + 18)
#define REG_CONTROL_OUT3                                        (256* 0 + 19)
#define REG_CONTROL_OUT4                                        (256* 0 + 20)
#define REG_CONTROL_OUT5                                        (256* 0 + 21)
#define REG_CONTROL_OUT6                                        (256* 0 + 22)
#define REG_CONTROL_OUT7                                        (256* 0 + 23)
#define REG_CONTROL_OUT8                                        (256* 0 + 24)
#define REG_CONTROL_OUT9                                        (256* 0 + 25)
#define REG_CONTROL_OUT10                                       (256* 0 + 26)
#define REG_CONTROL_OUT11                                       (256* 0 + 27)
#define REG_CONTROL_OUT12                                       (256* 0 + 28)
#define REG_CONTROL_OUT13                                       (256* 0 + 29)
#define REG_CONTROL_OUT14                                       (256* 0 + 30)
#define REG_CONTROL_OUT15                                       (256* 0 + 31)

#define REG_SUBZONE_OUT1                                        (256* 0 + 32)
#define REG_SUBZONE_OUT2                                        (256* 0 + 33)
#define REG_SUBZONE_OUT3                                        (256* 0 + 34)
#define REG_SUBZONE_OUT4                                        (256* 0 + 35)
#define REG_SUBZONE_OUT5                                        (256* 0 + 36)
#define REG_SUBZONE_OUT6                                        (256* 0 + 37)
#define REG_SUBZONE_OUT7                                        (256* 0 + 38)
#define REG_SUBZONE_OUT8                                        (256* 0 + 39)
#define REG_SUBZONE_OUT9                                        (256* 0 + 40)
#define REG_SUBZONE_OUT10                                       (256* 0 + 41)
#define REG_SUBZONE_OUT11                                       (256* 0 + 42)
#define REG_SUBZONE_OUT12                                       (256* 0 + 43)
#define REG_SUBZONE_OUT13                                       (256* 0 + 44)
#define REG_SUBZONE_OUT14                                       (256* 0 + 45)
#define REG_SUBZONE_OUT15                                       (256* 0 + 46)

#define REG_CONTROL_INP1                                        (256* 0 + 47)
#define REG_CONTROL_INP2                                        (256* 0 + 48)
#define REG_CONTROL_INP3                                        (256* 0 + 49)
#define REG_CONTROL_INP4                                        (256* 0 + 50)
#define REG_CONTROL_INP5                                        (256* 0 + 51)
#define REG_CONTROL_INP6                                        (256* 0 + 52)
#define REG_CONTROL_INP7                                        (256* 0 + 53)
#define REG_CONTROL_INP8                                        (256* 0 + 54)  //  register stored even though Mespelare hardware doesn't use this input

#define REG_SUBZONE_INP1                                        (256* 0 + 55)
#define REG_SUBZONE_INP2                                        (256* 0 + 56)
#define REG_SUBZONE_INP3                                        (256* 0 + 57)
#define REG_SUBZONE_INP4                                        (256* 0 + 58)
#define REG_SUBZONE_INP5                                        (256* 0 + 59)
#define REG_SUBZONE_INP6                                        (256* 0 + 60)
#define REG_SUBZONE_INP7                                        (256* 0 + 61)
#define REG_SUBZONE_INP8                                        (256* 0 + 62)  //  register stored even though Mespelare hardware doesn't use this input

#define REG_PTIME_OUT1                                          (256* 0 + 63)  // RW Output protection timer in multiples of 64 seconds./n Output will automatically disable after time
#define REG_PTIME_OUT2                                          (256* 0 + 64)
#define REG_PTIME_OUT3                                          (256* 0 + 65)
#define REG_PTIME_OUT4                                          (256* 0 + 66)
#define REG_PTIME_OUT5                                          (256* 0 + 67)
#define REG_PTIME_OUT6                                          (256* 0 + 68)
#define REG_PTIME_OUT7                                          (256* 0 + 69)
#define REG_PTIME_OUT8                                          (256* 0 + 70)
#define REG_PTIME_OUT9                                          (256* 0 + 71)
#define REG_PTIME_OUT10                                         (256* 0 + 72)
#define REG_PTIME_OUT11                                         (256* 0 + 73)
#define REG_PTIME_OUT12                                         (256* 0 + 74)
#define REG_PTIME_OUT13                                         (256* 0 + 75)
#define REG_PTIME_OUT14                                         (256* 0 + 76)
#define REG_PTIME_OUT15                                         (256* 0 + 77)

#define REG_STATUS_PWM1                                         (256* 0 + 78)  // RW Actual status of the PWM output (OUT4 = RB4)
#define REG_STATUS_PWM2                                         (256* 0 + 79)

#define REG_CONTROL_PWM1                                        (256* 0 + 80)
#define REG_CONTROL_PWM2                                        (256* 0 + 81)

#define REG_SUBZONE_PWM1                                        (256* 0 + 82)  // RW Subzone for PWM.
#define REG_SUBZONE_PWM2                                        (256* 0 + 83)

#define REG_ASSOUT_PWM1                                         (256* 0 + 84)  // RW Output associated with PWM./n Output will go active if PWM > treshold.
#define REG_ASSOUT_PWM2                                         (256* 0 + 85)

#define REG_TRESH_PWM1                                          (256* 0 + 86)  // RW Treshold value./n Above this PWM value the associated output will go active.
#define REG_TRESH_PWM2                                          (256* 0 + 87)

#define REG_MODE_OUT3                                           (256* 0 + 88)  // Operation mode of OUT3. 0x01 = output, 0x02 = PWM, 0x03=SoundPlay
#define REG_MODE_OUT4                                           (256* 0 + 89)  // Operation mode of OUT4. 0x01 = output, 0x02 = PWM,

#define PWM_OUT                                                 (256* 0 + 122)

#define USER_EEPROM_LAST_POS                                    127  //includes DM registers ?

// TODO: tackle problem with vscpworks incorrectly loading paginated registers
// see issue https://github.com/grodansparadis/vscp_software/issues/42


// --------------------------------------------------------------------------------


// * * * Actions * * *
#define ACTION_NOOP						 0
#define ACTION_ON						 1
#define ACTION_OFF						 2
#define ACTION_PULSE                                             3
#define ACTION_TOGGLE                                            4
#define ACTION_PWM                                               5


// * * * Relay control bits * * *
#define RELAY_CONTROLBIT_NOOP				0x01 	// Noop protection
#define RELAY_CONTROLBIT_ALARM				0x02 	// Send alarm on protection time activation
#define RELAY_CONTROLBIT_PROTECTION			0x04 	// Enable protection timer
#define RELAY_CONTROLBIT_ONEVENT			0x08 	// Send ON event
#define RELAY_CONTROLBIT_OFFEVENT			0x10 	// Semd OFF event
#define RELAY_CONTROLBIT_STARTEVENT			0x20 	// Send START event
#define RELAY_CONTROLBIT_STOPEVENT			0x40 	// Sned STOP event
#define RELAY_CONTROLBIT_ENABLED			0x80 	// Relay enabled

#define INP_CONTROLBIT_REDG                             0x01    //Send event at raising edge
#define INP_CONTROLBIT_RPT                              0x02    //send repeatingly events when input active
#define INP_CONTROLBIT_FEDG                             0x04    //Send event at falling edge


// PWM state machine states
#define PWM_OFF								0
#define PWM_UP								1
#define PWMMED_UP							2
#define PWM_DOWN							3
#define PWM_ON								4

#define NoSound     0
#define Beep1       1
#define Beep2       2
#define Song1       3
#define Song2       4

#endif
